@echo off

setlocal

set find=%SystemRoot%\system32\find.exe
set wmic=%SystemRoot%\system32\wbem\wmic.exe
set wusa=%SystemRoot%\system32\wusa.exe
set wusaSN=%SystemRoot%\SysNative\wusa.exe

set win=
ver | "%find%" "10.0." >NUL && set win=windows10.0
ver | "%find%" "6.3." >NUL && set win=windows8.1
ver | "%find%" "6.2." >NUL && set win=windows8.0
ver | "%find%" "6.1." >NUL && set win=windows6.1
ver | "%find%" "6.0." >NUL && set win=windows6.0
if "%win%"=="" (
    echo.
    echo #   Error determining the Windows version!
    goto :EOF
)

set arch=x64
if %PROCESSOR_ARCHITECTURE% == x86 (
    rem our process context is 32 bit, look further...
    if not defined PROCESSOR_ARCHITEW6432 (
        rem we run on a native 32 bit Windows
        set arch=x86
        rem we keep the system32 path to wusa as it is also true on 32 bit Windows
    ) else (
        rem we run as 32bit process on 64 bit windows
        rem \sysNative only exists on 64bit windows and is only visible in 32bit processes. It is a virtual folder to the true 64bit \system32 folder.
        set wusa=%wusaSN%
    )
)
rem output system values
for %%i IN (win arch wusa) DO (
    call echo    %%i = %%%%i%%
)
echo.

rem skip Windows Update configuration for all OS except Widnows 7
if "%win%" NEQ "windows6.1" (
	echo #   Windows Update configuration skipped.
	echo.
	goto :eof
)

rem resetting service start type to relevant services
echo.
echo #   Setting startup type for Windows Update service to demand...
sc config wuauserv start= demand

rem stopping windows update service
echo.
echo #   Stopping Windows Update Service...
net stop wuauserv 2>NUL

rem check for success
echo.
echo #   Check that Windows Update Service is STOPPED
sc query wuauserv | findstr /I /C:"STOPPED"
if errorlevel 1 (
	echo.
	echo #   Failed to stop the windows update service
	set RebootRequired=1
	goto :REBOOT
)

rem delete preloaded but not installed updates - This folder may contain broken files which harm a successful installation of our updates
echo.
echo #   Cleaning Windows Update download folder...
for /F "usebackq tokens=*" %%i in (`dir "%SystemRoot%\SoftwareDistribution\Download\" /b /ad`) do rd /s /q "%SystemRoot%\SoftwareDistribution\Download\%%i"
del /q /s "%SystemRoot%\SoftwareDistribution\Download\*.*"

rem --- getting pending Reboots
echo.
echo #   Getting Pending Windows reboot...
rem --- RebootRequired=0 without reboot / RebootRequired=1 reboot prerequested
set "RebootRequired=0"
reg query "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Component Based Servicing\RebootPending"
if "%errorlevel%"=="0" echo A reboot is needed. & set RebootRequired=1
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\WindowsUpdate\Auto Update\RebootRequired"
if "%errorlevel%"=="0" echo A reboot is needed. & set RebootRequired=1
rem --- This entry only stores files that need to be renamed after a reboot.
rem reg query "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager" /v PendingFileRenameOperations
rem if "%errorlevel%"=="0" echo A reboot is needed. & set RebootRequired=1

:REBOOT
if %RebootRequired% NEQ 0 (
	echo.
	echo RebootRequired is %RebootRequired%
	echo PC will be rebooted now.
	exit /b %RebootRequired%
)
echo #   Preparations completed.
